#!/bin/sh

me=[create-vpn-certs.sh]

EASYRSA=/usr/sbin/easy-rsa/easyrsa
# 10 clients are allowed to connect via tun device + 2 for the br0.
N_CLIENTS=1

if [ "new" = "$1" ]
then
  logger -t "${me}" "Removing PKI directory!"
  rm -rf /opt/userdata/openvpn/pki
fi

if ! [ -d /opt/userdata/openvpn/pki ]
then
  logger -t "${me}" "Initializing CA PKI."
  ${EASYRSA} init-pki
  logger -t "${me}" "Build CA."
  ${EASYRSA} build-ca nopass
  logger -t "${me}" "Create server keys."
  ${EASYRSA} gen-req server nopass
  ${EASYRSA} sign-req server server

  logger -t "${me}" "Create client keys for ${N_CLIENTS} client(s)."
  for i in `seq 1 ${N_CLIENTS}`
  do
    UNIQUE_POSTFIX=$(cat /dev/urandom | tr -cd 'a-f0-9' | head -c 4)
    # Export this for each client as this (C)ommon (N)ame needs to be unique for signing.
    export EASYRSA_REQ_CN="$(hostname) Client${i}${UNIQUE_POSTFIX}"
    ${EASYRSA} gen-req client${i} nopass
    ${EASYRSA} sign-req client client${i}
  done
fi

exit 0
